package edu.unl.consystlab.gui;

import javax.swing.JProgressBar;
import edu.unl.consystlab.sudoku.Game;

public class GameProgressBar extends JProgressBar
{
	private Game game;
	private int oldVal = -1;
	
	public GameProgressBar(Game game, int orientation)
	{
		super(orientation);
		this.setToolTipText("The progress of the solving process");
		this.game = game;
		
	}
	
	public void setProgressPct(int val)
	{
		if(val!=oldVal)
		{
			this.setValue(val);
			oldVal = val;
			this.repaint();
		}		
	}
}
